/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.event.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.RayTraceHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LockOnManager {
    public static LockOnManager getInstance() {
        return SingletonHolder.instance;
    }

    private LockOnManager() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onInputChange(InputCommandEvent event) {
        Entity targetEntity;
        if (event.getOld().contains((Object)InputCommand.SNEAK) == event.getCurrent().contains((Object)InputCommand.SNEAK)) {
            return;
        }
        ServerPlayer player = event.getEntity();
        ItemStack stack = event.getEntity().m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (!(stack.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        if (event.getOld().contains((Object)InputCommand.SNEAK) && !event.getCurrent().contains((Object)InputCommand.SNEAK)) {
            targetEntity = null;
        } else {
            Optional<HitResult> result = RayTraceHelper.rayTrace(player.m_9236_(), (Entity)player, player.m_20299_(1.0f), player.m_20154_(), 40.0, 40.0, e -> true);
            Optional<Entity> foundEntity = result.filter(r -> r.m_6662_() == HitResult.Type.ENTITY).filter(r -> {
                EntityHitResult er = (EntityHitResult)r;
                Entity target = er.m_82443_();
                if (target instanceof PartEntity) {
                    target = ((PartEntity)target).getParent();
                }
                boolean isMatch = false;
                if (target instanceof LivingEntity) {
                    isMatch = TargetSelector.lockon.m_26885_((LivingEntity)player, (LivingEntity)target);
                }
                return isMatch;
            }).map(r -> ((EntityHitResult)r).m_82443_());
            if (!foundEntity.isPresent()) {
                List entities = player.m_9236_().m_45971_(LivingEntity.class, TargetSelector.lockon, (LivingEntity)player, player.m_20191_().m_82377_(12.0, 6.0, 12.0));
                foundEntity = entities.stream().map(s -> s).min(Comparator.comparingDouble(e -> e.m_20280_((Entity)player)));
            }
            targetEntity = foundEntity.map(e -> e instanceof PartEntity ? ((PartEntity)e).getParent() : e).orElse(null);
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> s.setTargetEntityId(targetEntity));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onEntityUpdate(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mcinstance = Minecraft.m_91087_();
        if (mcinstance.f_91074_ == null) {
            return;
        }
        LocalPlayer player = mcinstance.f_91074_;
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (!(stack.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> {
            Entity target = s.getTargetEntity(player.m_9236_());
            if (target == null) {
                return;
            }
            if (!target.m_6084_()) {
                return;
            }
            LocalPlayer entity = player;
            if (!entity.m_9236_().m_5776_()) {
                return;
            }
            if (!entity.getCapability(CapabilityInputState.INPUT_STATE).filter(input -> input.getCommands().contains((Object)InputCommand.SNEAK)).isPresent()) {
                return;
            }
            float partialTicks = mcinstance.m_91296_();
            float oldYawHead = entity.f_20885_;
            float oldYawOffset = entity.f_20883_;
            float oldPitch = entity.m_146909_();
            float oldYaw = entity.m_146908_();
            float prevYawHead = entity.f_20886_;
            float prevYawOffset = entity.f_20884_;
            float prevYaw = entity.f_19859_;
            float prevPitch = entity.f_19860_;
            entity.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_().m_82520_(0.0, (double)target.m_20192_() / 2.0, 0.0));
            float step = 0.125f * partialTicks;
            step = (float)((double)step * Math.min(1.0, Math.abs((double)Mth.m_14177_((float)(oldYaw - entity.f_20885_)) * 0.5)));
            entity.m_146926_(Mth.m_14189_((float)step, (float)oldPitch, (float)entity.m_146909_()));
            entity.m_146922_(Mth.m_14189_((float)step, (float)oldYaw, (float)entity.m_146908_()));
            entity.m_5616_(Mth.m_14189_((float)step, (float)oldYawHead, (float)entity.m_6080_()));
            entity.f_20883_ = oldYawOffset;
            entity.f_20884_ = prevYawOffset;
            entity.f_20886_ = prevYawHead;
            entity.f_19859_ = prevYaw;
            entity.f_19860_ = prevPitch;
        });
    }

    private static final class SingletonHolder {
        private static final LockOnManager instance = new LockOnManager();

        private SingletonHolder() {
        }
    }
}

